# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to encourage Tit-for-Tat response
    if current_round == 1:
        return "C"
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    
    # If opponent cooperated in Round 1 (unlikely), continue cooperating
    if opp_history[0] == "C":
        return "C"
    
    # If opponent defected in Round 1 (expected), play modified Tit-for-Tat
    if current_round > 1:
        # Check for consecutive defections (more than twice)
        if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
            return "D"
        
        # Mirror opponent's last move with 10% chance of forgiveness
        if random.random() < 0.1:
            return "C"
        else:
            return opp_history[-1]
    
    # Default fallback (shouldn't reach here)
    return "D"